<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns="http://www.w3.org/1999/xhtml">

<xsl:output
	method="html"
	encoding="UTF-8"
	doctype-public="-//W3C//DTD XHTML 1.1//EN"
	doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
	indent="yes"
	cdata-section-elements="style script"/>

<xsl:template match="filterSettings">
    <table class="filterSettings">
        <tr>
            <td class="key">Date Range:</td>
            <td class="value">
                <xsl:value-of select="@dateRange"/>
            </td>
        </tr>
        <tr>
            <td class="key">Accounts:</td>
            <td class="value">
                <span class="andMore">and XXX more</span>
                <span class="singleItem">1 account</span>
                <span class="multipleItems">XXX accounts</span>
                <span class="zeroItems">All Accounts</span>
                <ul>
                    <xsl:apply-templates select="accounts/account"/>
                </ul>
            </td>
        </tr>
        <tr>
            <td class="key">Graph:</td>
            <td class="value"><label><input type="checkbox" name="yAxisStartsAtZero" onclick="NetWorthToggleYAxisStartsAtZero()" checked="true"/> Y-axis starts at zero</label></td>
        </tr>
    </table>
</xsl:template>

<xsl:template match="filterSettings/accounts/account">
    <li><xsl:value-of select="@name"/></li>
</xsl:template>

<!--<xsl:variable name="tagsType">
	<xsl:if test="count(ancestor::tags)=0">topLevel</xsl:if>
</xsl:variable>-->


<xsl:template match="/root">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<link rel="stylesheet" href="../css/default.css" type="text/css" media="all" charset="utf-8" />
		<link rel="stylesheet" href="../css/filterSettings.css" media="screen,print"  type="text/css" charset="utf-8"/>
		<link rel="stylesheet" href="../css/networth.css" type="text/css" media="all" charset="utf-8" />

        
        <script type="text/javascript" src="../js/jquery-1.10.2.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/spendingOverTime.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/deferredPrinting.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/barOrLinePlot.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/filterSettings.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/utils.js" charset="utf-8"></script>
        <script type="text/javascript" src="../js/highcharts.js" charset="utf-8"></script>
        <script type="text/javascript" src="../js/rounded-corners.js" charset="utf-8"></script>
        
        <style>
            /* Overide shared CSS style to remove pointer */
            #tableData tbody tr, .tableFixedData tbody tr{
            cursor:default;
            }
        </style>
		
		<script type="text/javascript">
	$(SpendingOverTimeInit);
	$(NetWorthPlotInit);
	$(CurrencyMenuInit);
		</script>
	</head>
	
	<body id="spendingOvertime">
		<div id="outerWrapper">
			<xsl:apply-templates select="filterSettings"/>
            <xsl:apply-templates select="currencies"/>

			<!-- We have any data to work with? -->
			<xsl:choose>
				<xsl:when test="count(plotData)">
					<!-- Begin: innerWrapper - PLOT data -->
					<div id="innerWrapper" class="fullWidth clearAfter">
						<xsl:apply-templates select="plotData"/>
					</div><!-- End: innerWrapper -->

					<xsl:choose>
						<xsl:when test="count(tableData/tags)">
							<!-- Begin: innerWrapper - SCREEN data -->
							<div id="innerWrapper" class="fullWidth clearAfter tableData">
								<div id="screenTable">
									<xsl:apply-templates select="tableData"/>
								</div>
							</div><!-- End: innerWrapper -->
						</xsl:when>

						<xsl:when test="count(printData/tags)">
							<!-- Begin: innerWrapper - PRINT data -->
							<div id="innerWrapper" class="fullWidth clearAfter printableData">
								<div id="printableTable">
									<xsl:apply-templates select="printData"/>
								</div>
							</div><!-- End: innerWrapper -->
						</xsl:when>		
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<!-- Begin: innerWrapper - NO data -->
					<div id="innerWrapperZeroDataCategory" class="fullWidth clearAfter">
						<div class="zeroState">
							<div class="noDataA">
								<p class="first">You have no transactions for the selected settings.</p>
								<p class="second">Try updating your settings above.</p>
							</div>	
						</div>
					</div><!-- End: innerWrapper -->
				</xsl:otherwise>				
			</xsl:choose>
		</div>
	</body>
	</html>
</xsl:template>

<!-- Creates the series of page-sized tables that will be printed -->
<xsl:template match="printData">
	<div id="printableDataContainer">
	<xsl:call-template name="recursive_printTable">
		<xsl:with-param name="start">1</xsl:with-param>
		<xsl:with-param name="end"><xsl:value-of select="count(/root/plotData/point)"/></xsl:with-param>
		<xsl:with-param name="increment">6</xsl:with-param>
	</xsl:call-template>
	</div>
</xsl:template>

<!-- Creates an individual page-sized table that will be printed -->
<!-- Parameters: -->
<!-- start=The first index to include in this table -->
<!-- end=The last index to include in this table -->
<!-- increment=the number of indices to include per page -->
<xsl:template name="recursive_printTable">
	<xsl:param name="start"/>
	<xsl:param name="end"/>
	<xsl:param name="increment"/>
	<div class="printableTable">
		<table class="tableFixedData" cellspacing="0" cellpadding="0">
			<thead>
				<tr>
					<td class="category">Account</td>
					<xsl:call-template name="recursive_headers">
						<xsl:with-param name="start"><xsl:value-of select="$start"/></xsl:with-param>
						<xsl:with-param name="end"><xsl:value-of select="$start+$increment"/></xsl:with-param>
					</xsl:call-template>
				</tr>
			</thead>
			<tbody>
				<xsl:apply-templates select="tags" mode="print">
						<xsl:with-param name="start"><xsl:value-of select="$start"/></xsl:with-param>
						<xsl:with-param name="end"><xsl:value-of select="$start+$increment"/></xsl:with-param>
						<xsl:with-param name="total"><xsl:value-of select="$end"/></xsl:with-param>
				</xsl:apply-templates>
			</tbody>
			<tfoot>
				<tr>
					<td class="category">Net Worth</td>
					<xsl:apply-templates select="totals" mode="print">
						<xsl:with-param name="start"><xsl:value-of select="$start"/></xsl:with-param>
						<xsl:with-param name="end"><xsl:value-of select="$start+$increment"/></xsl:with-param>
						<xsl:with-param name="total"><xsl:value-of select="$end"/></xsl:with-param>
					</xsl:apply-templates>
				</tr>
			</tfoot>
		</table>
	</div>
	<xsl:if test="$start+$increment &lt;= $end">
		<xsl:call-template name="recursive_printTable">
			<xsl:with-param name="start"><xsl:value-of select="$start+$increment"/></xsl:with-param>
			<xsl:with-param name="end"><xsl:value-of select="$end"/></xsl:with-param>
			<xsl:with-param name="increment"><xsl:value-of select="$increment"/></xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- Displays the values for the right-most Total column in the printed version -->
<xsl:template match="totals" mode="print">
	<xsl:param name="start"/>
	<xsl:param name="end"/>
	<xsl:param name="total"/>
	<xsl:call-template name="recursive_date">
		<xsl:with-param name="start"><xsl:value-of select="$start"/></xsl:with-param>
		<xsl:with-param name="end"><xsl:value-of select="$end"/></xsl:with-param>
		<xsl:with-param name="total"><xsl:value-of select="$total"/></xsl:with-param>
	</xsl:call-template>
</xsl:template>

<!-- Assists in displaying the values for the right-most Total column in the printed version -->
<xsl:template name="recursive_date">
	<xsl:param name="start"/>
	<xsl:param name="end"/>
	<xsl:param name="total"/>
	<xsl:if test="not($start = $end)">
		<xsl:for-each select="date">
			<xsl:if test="$start = position()">
				<xsl:choose>
					<xsl:when test="total[@sign='negative']">
						<td class="total negative"><xsl:value-of select="total"/></td>
					</xsl:when>
					<xsl:when test="total[@sign='zero']">
						<td class="total zero"><xsl:value-of select="total"/></td>
					</xsl:when>
					<xsl:otherwise>
						<td class="total"><xsl:value-of select="total"/></td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
		
		<!-- And recurse -->
		<xsl:call-template name="recursive_date">
			<xsl:with-param name="start"><xsl:value-of select="$start + 1"/></xsl:with-param>
			<xsl:with-param name="end"><xsl:value-of select="$end"/></xsl:with-param>
			<xsl:with-param name="total"><xsl:value-of select="$total"/></xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- Creates the values in the table for printing -->
<!-- Each 'tags' section contains multiple 'tag' elements -->
<!-- A 'tag' element may contain a 'tags' element, which calls back here -->
<xsl:template match="tags" mode="print">
	<xsl:param name="start"/>
	<xsl:param name="end"/>
	<xsl:param name="total"/>
	<xsl:apply-templates select="tag" mode="print">
		<xsl:with-param name="start"><xsl:value-of select="$start"/></xsl:with-param>
		<xsl:with-param name="end"><xsl:value-of select="$end"/></xsl:with-param>
		<xsl:with-param name="total"><xsl:value-of select="$total"/></xsl:with-param>
	</xsl:apply-templates>
</xsl:template>

<!-- Creates the category name table entry and 'start' -> 'end' table value columns -->
<xsl:template match="tag" mode="print">
	<xsl:param name="start"/>
	<xsl:param name="end"/>
	<xsl:param name="total"/>
	<xsl:variable name="categoryClass">
		<xsl:if test="@quickenID='Uncategorized'">uncategorized</xsl:if>
	</xsl:variable>
	
	<xsl:variable name="level">
		<xsl:value-of select="count(ancestor::tags) - 1"/>
	</xsl:variable>
	
	<tr class="category {$categoryClass} level{$level}" level="{$level}" quickenID="{@quickenID}">
		<td class="category level{$level}" id="categoryName_{@node_Name}"><xsl:value-of select="@nodeName"/></td>
		<xsl:call-template name="recursive_total">
			<xsl:with-param name="start"><xsl:value-of select="$start"/></xsl:with-param>
			<xsl:with-param name="end"><xsl:value-of select="$end"/></xsl:with-param>
		</xsl:call-template>
	</tr>
	
	<xsl:apply-templates select="tags" mode="print">
		<xsl:with-param name="start"><xsl:value-of select="$start"/></xsl:with-param>
		<xsl:with-param name="end"><xsl:value-of select="$end"/></xsl:with-param>
		<xsl:with-param name="total"><xsl:value-of select="$total"/></xsl:with-param>
	</xsl:apply-templates>
</xsl:template>

<!-- Creates the bottom total values for a table to print -->
<xsl:template name="recursive_total">
	<xsl:param name="start"/>
	<xsl:param name="end"/>
	<xsl:if test="not($start = $end)">
		<xsl:for-each select="total">
			<xsl:if test="$start = position()">
				<xsl:choose>
					<xsl:when test="@sign='negative'">
						<td class="negative"><xsl:value-of select="."/></td>
					</xsl:when>
					<xsl:when test="@sign='zero'">
						<td class="zero"><xsl:value-of select="."/></td>
					</xsl:when>
					<xsl:otherwise>
						<td><xsl:value-of select="."/></td>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
		
		<!-- And recurse -->
		<xsl:call-template name="recursive_total">
			<xsl:with-param name="start"><xsl:value-of select="$start + 1"/></xsl:with-param>
			<xsl:with-param name="end"><xsl:value-of select="$end"/></xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- Creates the top column header (dates) for a table to print -->
<xsl:template name="recursive_headers">
	<xsl:param name="start"/>
	<xsl:param name="end"/>
	<xsl:if test="not($start = $end)">
		<xsl:for-each select="/root/plotData/point">
			<xsl:if test="$start = position()">
				<td><xsl:value-of select="@humanTitle"/></td>
			</xsl:if>
		</xsl:for-each>
		
		<!-- And recurse -->
		<xsl:call-template name="recursive_headers">
			<xsl:with-param name="start">
				<xsl:value-of select="$start + 1"/>
			</xsl:with-param>
			<xsl:with-param name="end">
				<xsl:value-of select="$end"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<xsl:template match="plotData">
    <div class="netWorthPlot" style="width: 100%; height: 250px; margin-left: -17px; padding-top: 20px; display: block; float: left;"></div>

	<ul class="plotData">
		<xsl:apply-templates select="point"/>
	</ul>
</xsl:template>


<xsl:template match="point">
	<li>
		<span class="humanTitle"><xsl:value-of select="@humanTitle"/></span>
		<span class="mediumHumanTitle"><xsl:value-of select="@mediumHumanTitle"/></span>
		<span class="shortHumanTitle"><xsl:value-of select="@shortHumanTitle"/></span>
		<span class="shortHumanSubtitle"><xsl:value-of select="@shortHumanSubtitle"/></span>
		<span class="rawValue"><xsl:value-of select="@rawTotal"/></span>
		<xsl:choose>
			<xsl:when test="total[@sign='negative']">
				<span class="humanValue negative"><xsl:value-of select="total"/></span>
			</xsl:when>
			<xsl:when test="total[@sign='zero']">
				<span class="humanValue zero"><xsl:value-of select="total"/></span>
			</xsl:when>
			<xsl:otherwise>
				<span class="humanValue"><xsl:value-of select="total"/></span>
			</xsl:otherwise>
		</xsl:choose>
		<span class="transactionCount"><xsl:value-of select="@transactionCount"/></span>
	</li>
</xsl:template>

<!-- Start of SCREEN table generation -->
<xsl:template match="tableData">
		<div id="tableFixedDataContainer">
			<table class="tableFixedData" cellspacing="0" cellpadding="0">
				<thead>
					<tr>
						<td class="category">Account</td>
					</tr>
				</thead>
				
				<tbody>
					<xsl:apply-templates select="tags" mode="fixedScreen"/>
				</tbody>
				
				<tfoot>
					<tr>
						<td class="category total">Net Worth</td>
					</tr>
					<tr>
						<td></td>
					</tr>
				</tfoot>
			</table>
		</div>
		
		<div id="tableDataContainer">
			<table id="tableData" cellspacing="0" cellpadding="0">
				<thead>
					<tr>
						<xsl:for-each select="/root/plotData/point">
							<td id="monthHeader_{@humanTitle}"><xsl:value-of select="@humanTitle"/></td>
						</xsl:for-each>
					</tr>
				</thead>
				
				<tbody>
					<xsl:apply-templates select="tags" mode="valueScreen"/>
				</tbody>
				
				<tfoot>
					<tr>
						<xsl:apply-templates select="totals"/>
					</tr>
					<tr>
						<xsl:for-each select="/root/plotData/point">
							<td id="footer_{@humanTitle}"><xsl:value-of select="@humanTitle"/></td>
						</xsl:for-each>
					</tr>
					
				</tfoot>
			</table>
		</div>
</xsl:template>

<xsl:template match="tags" mode="fixedScreen">
	<xsl:apply-templates select="tag" mode="fixedScreen"/>
</xsl:template>

<xsl:template match="tag" mode="fixedScreen">
	<xsl:variable name="categoryClass">
		<xsl:if test="@quickenID='Uncategorized'">uncategorized</xsl:if>
	</xsl:variable>
	
	<xsl:variable name="level">
		<xsl:value-of select="count(ancestor::tags) - 1"/>
	</xsl:variable>
	
	<tr class="category {$categoryClass} level{$level}" level="{$level}" quickenID="{@quickenID}">
		<td class="category level{$level}" id="account_{@nodeName}"><xsl:value-of select="@nodeName"/></td>
	</tr>
	
	<xsl:apply-templates select="tags" mode="fixedScreen"/>
</xsl:template>

<xsl:template match="tags" mode="valueScreen">
	<xsl:apply-templates select="tag" mode="valueScreen"/>
</xsl:template>

<xsl:template match="tag" mode="valueScreen">
	<xsl:variable name="categoryClass">
		<xsl:if test="@quickenID='Uncategorized'">uncategorized</xsl:if>
	</xsl:variable>
	
	<xsl:variable name="level">
		<xsl:value-of select="count(ancestor::tags) - 1"/>
	</xsl:variable>
	
	<tr class="category {$categoryClass} level{$level}" level="{$level}" quickenID="{@quickenID}">
		<xsl:apply-templates select="total"/>
	</tr>
	
	<xsl:apply-templates select="tags" mode="valueScreen"/>
</xsl:template>


<xsl:template match="total">
	<xsl:choose>
		<xsl:when test="@sign='negative'">
			<td class="negative" id="total_{../@nodeName}_{@humanTitle}"><xsl:value-of select="."/></td>
		</xsl:when>
		<xsl:when test="@sign='zero'">
			<td class="zero" id="total_{../@nodeName}_{@humanTitle}"><xsl:value-of select="."/></td>
		</xsl:when>
		<xsl:otherwise>
			<td id="total_{../@nodeName}_{@humanTitle}"><xsl:value-of select="."/></td>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="date">
	<xsl:choose>
		<xsl:when test="total[@sign='negative']">
			<td class="total negative" id="total_{@humanTitle}"><xsl:value-of select="total"/></td>
		</xsl:when>
		<xsl:when test="total[@sign='zero']">
			<td class="total zero" id="total_{@humanTitle}"><xsl:value-of select="total"/></td>
		</xsl:when>
		<xsl:otherwise>
			<td class="total" id="total_{@humanTitle}"><xsl:value-of select="total"/></td>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="totals">
	<xsl:apply-templates select="date"/>
</xsl:template>


<!-- Currencies -->

<xsl:template match="currencies">
	<xsl:if test="count(currency) > 1">
        <div class="currencies_select_div">
            <select id="currencyTypeSelect">
                <xsl:apply-templates select="currency"/>
            </select>
            <div class="select_arrow_wrapper">
                <div class="arrow_up"></div>
                <div class="arrow_down"></div>
            </div>
        </div>
	</xsl:if>
</xsl:template>


<xsl:template match="currency">
	<xsl:choose>
		<xsl:when test="@selected='YES'">
			<option value="{@currencyID}" selected=""><xsl:value-of select="@title"/></option>
		</xsl:when>
		<xsl:otherwise>
			<option value="{@currencyID}"><xsl:value-of select="@title"/></option>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>
